Rem
Rem $Header: mgw/samples/jms/jms_adm_setup.sql /mgw_main/4 2012/08/11 01:05:15 pabhat Exp $
Rem
Rem jms_adm_setup.sql
Rem
Rem Copyright (c) 2003, 2012, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      jms_adm_setup.sql - SQL script to configure the MGW entities
Rem
Rem    DESCRIPTION
Rem    SQL script to configure the MGW entities using the admin package.
Rem    This script sets up a JMS "round-trip" propagation to illustrate both
Rem    outbound (AQ->MQ) and inbound (MQ->AQ) propagation. An outbound
Rem    propagation job moves messages from the AQ queue MGWUSER.JMS_TEXTQ to
Rem    a user supplied WebSphere MQ queue. An inbound propagation job moves
Rem    messages from the same user supplied WebSphere MQ queue to the AQ 
Rem    queue MGWUSER.JMS_TEXTT. The end result should be messages moved from
Rem    MGWUSER.JMS_TEXTQ to MGWUSER.JMSTEXTT.
Rem
Rem 
Rem PREREQUISITES:
Rem
Rem * The following database entities are assumed:
Rem   - Users: mgwagent, mgwadm, mgwuser
Rem   - AQ Queues: mgwuser.jms_textq, mgwuser.jms_textt
Rem
Rem --------------------------------------------------------------------------
Rem
Rem This script does the following (via the dbms_mgwadm package):
Rem
Rem * Sets the agent user connection information:
Rem   username:     mgwagent
Rem   password:     mgwagent
Rem   service_name: <user supplied>
Rem
Rem * Creates an WebSphere MQ JMS link
Rem   Link name: mqjms_link
Rem
Rem * Creates an MQ foreign queue.
Rem   Name:   mqjms_queue
Rem   Link:   mqjms_link
Rem   Native: <user supplied>
Rem
Rem * Creates an OUTBOUND propagation job.
Rem   Job:    job_mqjms_out
Rem   Source: mgwuser.jms_textq
Rem   Dest:   mqjms_queue@mqjms_link
Rem
Rem * Creates an INBOUND propagation job.
Rem   Job:    job_mqjms_in
Rem   Source: mqjms_queue@mqjms_link
Rem   Dest:   mgwuser.jms_textt
Rem
Rem ==========================================================================

connect mgwadm/mgwadm;

variable gv_database            VARCHAR2(32);
variable gv_mq_queue_manager    VARCHAR2(32);
variable gv_mq_queue_name       VARCHAR2(32);
variable gv_mq_channel          VARCHAR2(32);
variable gv_mq_inbound_log_queue  VARCHAR2(32);
variable gv_mq_outbound_log_queue VARCHAR2(32);
variable gv_mq_username         VARCHAR2(32);
variable gv_mq_password         VARCHAR2(32);
variable gv_mq_host             VARCHAR2(48);
variable gv_mq_port             VARCHAR2(6);

--
-- WARNING!!!! The values below must be set before this script is run.
--
begin
  :gv_database         := '';     -- database specifier for agent user
  :gv_mq_queue_manager := '';
  :gv_mq_queue_name    := '';
  :gv_mq_channel       := '';
  :gv_mq_host          := '';
  :gv_mq_port          := '';
  :gv_mq_username      := '';     -- MQ user name
  :gv_mq_password      := '';     -- MQ user password
  :gv_mq_inbound_log_queue := '';
  :gv_mq_outbound_log_queue := '';
end;
/

prompt
prompt Setting the gateway agent user for the default agent
prompt 

Rem   If we do not set the database argument it will default to the
Rem   ORACLE_SID of the MGW process (the listener process).
begin
  dbms_mgwadm.alter_agent(
      agent_name => 'default_agent',
      username   => 'mgwagent',
      password   => 'mgwagent',
      database   => RTRIM(:gv_database));
end;
/

prompt
prompt Creating WebSphere MQ JMS link
prompt

declare
  v_options sys.mgw_properties := NULL;
  v_prop    sys.mgw_mqseries_properties;
begin
  if (:gv_mq_queue_manager IS NULL) then
    dbms_output.put_line('queue manager must be specified');
  end if;

  -- set options if desired

  -- set certain properties used for WebSphere MQ JMS
  -- NOTE: This information must be changed for your WebSphere MQ JMS setup.
  v_prop := sys.mgw_mqseries_properties.construct();

  -- Use a JMS unified, domain-independent connection. Queues, not topics,
  -- must be used for the MGW log queues for links using unified connections.
  v_prop.interface_type := dbms_mgwadm.JMS_CONNECTION;

  v_prop.max_connections := 1;

  -- queue manager name (required)
  v_prop.queue_manager := RTRIM(:gv_mq_queue_manager);

   -- hostname for queue manager host (required)
  v_prop.hostname := RTRIM(:gv_mq_host);

  -- channel name (required)
  v_prop.channel  := RTRIM(:gv_mq_channel);

  -- port (required -- 1414 is WebSphere MQ JMS default)
  v_prop.port := RTRIM(:gv_mq_port);

  -- username given to queue manager
  if (:gv_mq_username IS NOT NULL) then
    v_prop.username := RTRIM(:gv_mq_username);
  end if;

  -- password given to queue manager
  if (:gv_mq_password IS NOT NULL) then
    v_prop.password := RTRIM(:gv_mq_password);
  end if;

  -- name of WebSphere MQ JMS queue to be used for MGW logging on inbound jobs
  if (:gv_mq_inbound_log_queue IS NOT NULL) then
    v_prop.inbound_log_queue := RTRIM(:gv_mq_inbound_log_queue);
  end if;

  -- name of WebSphere MQ JMS queue to be used for MGW logging on outbound jobs
  if (:gv_mq_outbound_log_queue IS NOT NULL) then
    v_prop.outbound_log_queue := RTRIM(:gv_mq_outbound_log_queue);
  end if;

  -- create link
  dbms_mgwadm.create_msgsystem_link(
      linkname   => 'mqjms_link',     -- link name
      agent_name => 'default_agent',  -- MGW agent responsible for this link
      properties => v_prop,           -- WebSphere MQ JMS driver properties
      options    => v_options);       -- optional link options
end;
/

prompt
prompt Registering foreign queue
prompt

declare
  v_options sys.mgw_properties;
begin

  dbms_mgwadm.register_foreign_queue(
      name     => 'mqjms_queue',   -- MGW foreign queue name
      linkname => 'mqjms_link',    -- name of link to use
      provider_queue  => RTRIM(:gv_mq_queue_name), -- name of WebSphere MQ JMS queue
      domain  => dbms_mgwadm.DOMAIN_QUEUE, -- single consumer queue
      options => v_options );
end;
/

prompt
prompt Adding outbound propagation job
prompt

begin
  -- source must be an AQ queue (schema.name)
  -- destination must be a registered non-Oracle queue (queue@link)
  -- subscriber rule applies to AQ JMS subscriber
  -- exception queue, if any, must be a NORMAL AQ queue with same payload
  --   type as the source queue (schema.name)
  --
  -- for this sample:
  -- no selection rule used for this job
  -- no transformation used for this job (not valid for JMS)
  -- no exception queue
  dbms_mgwadm.create_job(
      job_name    => 'job_mqjms_out',
      propagation_type => dbms_mgwadm.outbound_propagation,
      source      => 'mgwuser.jms_textq',       -- AQ queue
      destination => 'mqjms_queue@mqjms_link'); -- registered non-Oracle queue
end;
/

prompt
prompt Adding inbound propagation job
prompt

begin
  -- source must be a registered non-Oracle queue (queue@link)
  -- destination must be an AQ queue (schema.name)
  -- subscriber rule applies to non-Oracle JMS subscriber 
  -- exception queue, if any, must be a registered non-Oracle queue that
  --   uses the same link as the source queue (queue@link)
  --
  -- for this sample:
  -- no selection rule used for this job
  -- no transformation used for this job (not valid for JMS)
  -- no exception queue
  dbms_mgwadm.create_job(
      job_name    => 'job_mqjms_in',
      propagation_type => dbms_mgwadm.inbound_propagation,
      source	  => 'mqjms_queue@mqjms_link', -- registered non-Oracle queue
      destination => 'mgwuser.jms_textt');     -- AQ queue
end;
/
